/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.comparedisks;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.comparedisks.CompareDisksWizard;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class CompareDisksResultsPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private Composite parent;
    private Object layoutData;
    private Composite control;
    private CompareDisksWizard wizard;

    public CompareDisksResultsPane(Composite parent, CompareDisksWizard wizard, Object layoutData) {
        this.parent = parent;
        this.wizard = wizard;
        this.layoutData = layoutData;
    }

    @Override
    public void open() {
        this.control = new Composite(this.parent, 0);
        this.control.setLayoutData(this.layoutData);
        this.wizard.enableNextButton(false);
        this.wizard.enableFinishButton(true);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.control.setLayout(layout);
        String message = this.compareDisks();
        Label label = new Label(this.control, 64);
        label.setText(message);
        label = new Label(this.control, 64);
        label.setText(this.textBundle.get("CompareDisksResultsPane.RestartText"));
    }

    @Override
    public WizardPane getNextPane() {
        return null;
    }

    @Override
    public void dispose() {
        this.control.dispose();
        this.control = null;
    }

    protected String compareDisks() {
        StringBuffer errorMessages = new StringBuffer();
        FormattedDisk[] disk1 = null;
        try {
            disk1 = new Disk(this.wizard.getDiskname1()).getFormattedDisks();
        }
        catch (Throwable t) {
            errorMessages.append(this.textBundle.format("CompareDisksResultsPane.UnableToLoadDiskN", new Object[]{new Integer(1), t.getLocalizedMessage()}));
        }
        FormattedDisk[] disk2 = null;
        try {
            disk2 = new Disk(this.wizard.getDiskname2()).getFormattedDisks();
        }
        catch (Throwable t) {
            errorMessages.append(this.textBundle.format("CompareDisksResultsPane.UnableToLoadDiskN", new Object[]{new Integer(2), t.getLocalizedMessage()}));
        }
        if (disk1 != null && disk2 != null) {
            if (disk1.length != disk2.length) {
                errorMessages.append(this.textBundle.get("CompareDisksResultsPane.DifferentSizeError"));
            } else {
                boolean disk2TSformat;
                boolean disk1TSformat = disk1[0].isCpmFormat() || disk1[0].isDosFormat() || disk1[0].isRdosFormat();
                boolean bl = disk2TSformat = disk2[0].isCpmFormat() || disk2[0].isDosFormat() || disk2[0].isRdosFormat();
                if (disk1TSformat && disk2TSformat) {
                    if (!AppleUtil.disksEqualByTrackAndSector(disk1[0], disk2[0])) {
                        errorMessages.append(this.textBundle.get("CompareDisksResultsPane.DataDiffersMessage"));
                    }
                } else if (!disk1TSformat && !disk2TSformat) {
                    if (!AppleUtil.disksEqualByBlock(disk1[0], disk2[0])) {
                        errorMessages.append(this.textBundle.get("CompareDisksResultsPane.DataDiffersMessage"));
                    }
                } else {
                    errorMessages.append(this.textBundle.get("CompareDisksResultsPane.DifferentDataFormatError"));
                }
            }
        }
        if (errorMessages.length() == 0) {
            return this.textBundle.get("CompareDisksResultsPane.DisksMatch");
        }
        return errorMessages.toString();
    }
}

